# -------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License.
# --------------------------------------------------------------------------

# This file can be modified by setup.py when building a manylinux2010 wheel
# When modified, it will preload some libraries needed for the python C extension
from ctypes import CDLL, RTLD_GLOBAL
try:
    _librocblas = CDLL("librocblas.so.0", mode=RTLD_GLOBAL)
    _libMIOpen = CDLL("libMIOpen.so.1", mode=RTLD_GLOBAL)
    _librccl = CDLL("librccl.so.1", mode=RTLD_GLOBAL)
    _libamdhip64 = CDLL("libamdhip64.so.5", mode=RTLD_GLOBAL)
except OSError:
    import os
    os.environ["ORT_CUDA_UNAVAILABLE"] = "1"
